//
// C Interface for MDF4Writer.dll
//

	INT_PTR M4WRInitDll(void);
	void M4WRExitDll(void);
	BOOL M4WRCreateMDF4(const wchar_t* strToolName, const wchar_t* strToolVendor, const wchar_t* strToolVersion, const wchar_t* strComment, INT_PTR lVersion);
	void M4WRSetPathName(const wchar_t* strName);
	void M4WRAddGroup(const wchar_t* strComment, unsigned int ExpNValues, INT_PTR* iNo);
	void M4WRAddGroup64(const wchar_t* strComment, __int64 ExpNValues, INT_PTR* iNo);
	BOOL M4WRAddSignal(long iGroupNo, const wchar_t* strName, const wchar_t* strLabel, long lDataType, long lnFirstBit, long lnBits, const wchar_t* strUnit, double yFactor, double yOffset, long bHasNovalues, double Novalue, long invalPos, long* iNo);
	BOOL M4WRAddTimeInfo(long iGroupNo, const wchar_t* strName, const wchar_t* strUnit, double Factor, double Offset);
	BOOL M4WRAddTimeSignal(long iGroupNo, const wchar_t* strName, long lDataType, long lnFirstBit, long lnBits, const wchar_t* strUnit, double Factor, double Offset, long* iNo);
	BOOL M4WRMakeGroups();
	BOOL M4WRSetSignalValue(long iGroupNo, long iSignalNo, double Value, long bIsNovalue);
	BOOL M4WRWriteRecord(long iGroupNo);
	BOOL M4WRFlushGroup(long iGroupNo);
	void M4WRClose();
	BOOL M4WRCreateSRBlock(long lGroupNo, double dt, double xrange, double OldXFactor, double OldXOffset);
	void M4WRSetFileTime(__int64 FileTime);
	BOOL M4WRGroupDescription(long lGroupNo, const wchar_t* strAcqName, const wchar_t* strCGComment, const wchar_t* strSIName, const wchar_t* strSIPath, const wchar_t* strSIComment);
	BOOL M4WRSignalDescription(long iGroupNo, long iSignalNo, const wchar_t* strSIName, const wchar_t* strSIPath, const wchar_t* strSIComment);
	unsigned int M4WRGetRecordSize(long lGroupID);
	void M4WRSetRecord(long lGroupNo, BYTE* pBuffer);
	BOOL M4WRSetMinMax(long iGroupNo, long iSignalNo, double Min, double Max);
	long M4WRGetInvalidBytes(long lGroupID);
	BOOL M4WRFileDescription(const wchar_t* strHDComment, long lTimerQualityClass, __int64 start_time_ns, WORD tz_offset_min, WORD dst_offset_min, BYTE time_flags);
	BOOL M4WRSetSignalDiscrete(long iGroupNo, long iSignalNo, long bDiscrete, const wchar_t* strN2T);
	BOOL M4WRSetTimeStat(long iGroupNo, double xMean, double xMin, double xMax, double xMinDelta, double xMaxDelta);
	BOOL M4WRSetRecordValues(long iGroupNo, double *pValues, long nRecords);
	void M4WRCreateSRBlocks();
	void M4WRSetFileTimeFraction(double FileTimeFraction);
	void M4WRSetNanoTimeUTC(__int64 NanoTimeUTC);
	BOOL M4WRWriteRecords(long iGroupNo, void *pBuffer, long nRecords);

