﻿// enumeration for member cn_data_type
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MDF4Writer;


namespace CSharpWriterExample
{
    class Program
    {
        static void Main(string[] args)
        {
            int CN_D_UINT_LE = 0;  // Unsigned Integer LE Byte Order
            int CN_D_SINT_LE = 2;  // Signed Integer LE Byte Order
            int CN_D_FLOAT_LE = 4;  // Float (IEEE 754) LE Byte Order

            MDF4Writer.MDF4Writer m4 = new MDF4Writer.MDF4Writer();
            int idGroup1, idGroup2;
            int idSignal0, idSignal1, idSignal2, idSignal3, idSignal4, idSignal5, idSignal6;
            int i;
	        int i64N = 10000;
	        double xmin=0, xmax=0, xrange=0, x=0, xoffset = 0;
            System.Random rand = new Random();

	        // if file exists, delete it first
	        // if (access("C:\\Temp\\M4Test.mf4",0)==0)
		    //     _tunlink("C:\\Temp\\M4Test.mf4");
	        // Set the file name before you create the file
	        m4.strPathName = "C:\\Temp\\M4Test.mf4";
	        m4.CreateMDF4( "Caller", "Lego", "1.0", "No comment", 410); // Version MDF4.10
            // Add a group with an equidistant, virtual time signal with 10 Hz sampling rate and 10 s offset
            m4.AddGroup("Group 1 Test", i64N, out idGroup1);
            m4.AddTimeInfo(idGroup1, "Time", "s", 0.1, 10);
            // Square wave, unsigned int 8 bit
            m4.AddSignal(idGroup1, "Square", "Signal with square wave", CN_D_UINT_LE, 8, "V", 1.0, 0.0, 0, 0.0, out idSignal0);
            // Sawtooth wave, signed int 8 bit
            m4.AddSignal(idGroup1, "Sawtooth", "Signal with sawtooth wave", CN_D_SINT_LE, 8, "A", 1.0, 0.0, 0, 0.0, out idSignal1);
            // Rampe, double 
            m4.AddSignal(idGroup1, "Ramp", "Signal with ramp wave", CN_D_FLOAT_LE, 64, "m", 1.0, 0.0, 0, 0.0, out idSignal2);

            // Add a group with a non-equidistant time signal with approx. 10 Hz sampling rate and 0 s offset
            m4.AddGroup64("Group 2 Test", i64N, out idGroup2);
            m4.AddTimeSignal(idGroup2, "Time", CN_D_FLOAT_LE, 64, "s", out idSignal3);
            m4.AddSignal(idGroup2, "Square", "Signal with square wave", CN_D_UINT_LE, 8, "V", 1.0, 0.0, 1, -100.0, out idSignal4);
            m4.AddSignal(idGroup2, "Sawtooth", "Signal with sawtooth wave", CN_D_SINT_LE, 8, "A", 0.1, -5.0, 1, 0.0, out idSignal5);
            m4.AddSignal(idGroup2, "Ramp", "Signal with ramp wave", CN_D_FLOAT_LE, 64, "m", 1.0, 0.0, 1, 0.0, out idSignal6);

	        // Now create the groups and channels in the MDF4 file 
	        m4.MakeGroups();
	        // After this, do not change/add groups or signals

	        // Write the data
	        for (i=0; i<i64N; i++)
	        {
		        // Group 1
		        m4.SetSignalValue( idGroup1, idSignal0, i<i64N/2 ? 0.0 : 255.0, 0);
		        m4.SetSignalValue( idGroup1, idSignal1, (double)(i%10)-5, 0);
		        m4.SetSignalValue( idGroup1, idSignal2, (double)i, 0);
		        m4.WriteRecord( idGroup1 );

		        // Group 2
		        x = (double)i/10 + (double)(rand.Next(32768)-16384)/1638400.0;
		        if (i > i64N/2 && xoffset == 0)
			        xoffset = x;
		        x += xoffset;
		        if (i==0)
			        xmin = x;
		        else
			        xmax = x;
		        m4.SetSignalValue( idGroup2, idSignal3, x, 0);
		        int noval = 0;
		        if (i == i64N/2)
			        noval = 1;
		        m4.SetSignalValue( idGroup2, idSignal4, i<i64N/2 ? 0.0 : 255.0, noval);
		        m4.SetSignalValue( idGroup2, idSignal5, (double)(i%10)-5, noval);
		        m4.SetSignalValue( idGroup2, idSignal6, (double)i, noval);
		        m4.WriteRecord( idGroup2 );
	        }
	        // Flush records, close open data blocks
	        m4.FlushGroup( idGroup1 );
	        m4.FlushGroup( idGroup2 );

	        // Close the file
	        m4.Close();

            // Create signal reduction blocks ??
	        //m4.CreateSRBlock(1,0.5, i64N * 0.1);
	        //m4.CreateSRBlock(1,1, i64N * 0.1);

	        xrange = xmax - xmin;
	        //m4.CreateSRBlock(2,0.5, xrange);

        }
    }
}
