// mdf324.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "mdf4.h"

#if 1 // writing an MDF4 file

int _tmain(int argc, _TCHAR* argv[])
{
  // Needed for XML support
  CoInitialize(NULL);

  // Create the Test-File
  MDF4File m4;
  if (m4.Create(_T("Test.mf4")))
  {
    // There MUST be at least one FileHistory (FH)
    // which MUST have an MD-Block
    M4FHComment fc(_T("First Test of MDF4 library"));
    fc.setToolName(_T("MyTool"));
    fc.setToolVendor(_T("MyCompany"));
    fc.setToolVersion(_T("0.1"));
    fc.closeXML();
    // Create the FH-Block
    M4FHBlock *fh=new M4FHBlock();
    fh->Create(&m4);
    // add the comment
    fh->setComment(fc);
    // and add to the HD Block
    m4.addHistory(fh);

#if 0
    // AT Attachment block
    M4ATBlock *at=new M4ATBlock(&m4);
    at->EmbedFile(_T("C:\\filter.dat"),false,true);
    m4.addAttachment(at);
#endif

    // UTF8-Test
    M4TXBlock Comment(_T("Michael Bhrer & special characters:   "));
    // MD-Block XML test
    M4HDComment hdComment(_T("No comment specified"));
    hdComment.setAuthor(_T("Autor"));
    hdComment.setDepartment(_T("Department"));
    hdComment.setProject(_T("Project"));
    hdComment.setSubject(_T("Subject"));
    hdComment.setTimeSource(_T("local PC reference timer"));
    hdComment.closeXML();
    m4.setComment(hdComment);

    // Create one DG with one CG with two CN's
    // Note: hd.addDataGroup, dg.addChannelGroup, cg.addChannel
    // must be called with an allocated object; they will be deleted
    // when the next object is added or in the destructor!
    M4DGBlock *dg=m4.addDataGroup(new M4DGBlock);
    dg->setComment(M4TXBlock(_T("DataGroup Comment")));
    M4CGBlock *cg=dg->addChannelGroup(new M4CGBlock);
    cg->setAcqName(M4TXBlock(_T("AcqName")));
    cg->setRecordSize(8+4,0);
	  dg->Save(true,true);

    // add the TIME channel
    M4CNBlock *cn=cg->addChannel(new M4CNBlock(CN_T_MASTER)); 
	  cg->Save(true,true);
    cn->setComment(M4TXBlock(_T("Time Channel")));
    cn->setName(M4TXBlock(_T("Time")));
    cn->setConversion(M4CCLinear(0.0031));
    cn->setLocation(CN_D_UINT_LE,0*8,8*8); // data type: uint 64
    // add the Value channel; CAUTION this will delete the cn!
    cn=cg->addChannel(new M4CNBlock(CN_T_FIXEDLEN));
    cn->setComment(M4TXBlock(_T("Value Channel")));
    cn->setName(M4TXBlock(_T("Value")));
    cn->setConversion(M4CCLinear(0.25,-800));
    cn->setLocation(CN_D_UINT_LE,8*8,4*8); // data type: DWORD

		M_UINT32 uiDataRecordSize = cg->cg_data_bytes + dg->dg_rec_id_size; // + rec id
		// the following code is crucial for the effectiveness of storing/reading the data:
		M_UINT32 uiNoOfRecords = 10; // No. of record per block
		// A data block should be large enough to be read effectively, but small enough to avoid empty space. 
		M_UINT32 uiDataBlockSize = uiDataRecordSize * uiNoOfRecords; // a good size for large file is 5 MB per block
		M4DTBlock *dt = dg->addDataBlock( new M4DTBlock(uiDataRecordSize, uiNoOfRecords), cg);
		BYTE *pRecord = (BYTE*)calloc(uiDataRecordSize,1);
		for (M_UINT32 i=1; i<=uiNoOfRecords; i++)
		{
			BYTE *p = pRecord;
			if (dg->dg_rec_id_size)
			{
				*p = (BYTE)1; // record id
				p+=dg->dg_rec_id_size;
			}
			*(__int64*)p = (__int64)i; // time
			p += sizeof(__int64);
			*(DWORD*)p = (DWORD)i*10; // Value
			//p += sizeof(DWORD); // no invalid bytes used here

			dt->addRecord( pRecord ); // append
		}
		free(pRecord);
		dt->Save(true,true);
		M4DTBlock *dt1 = dg->addDataBlock( new M4DTBlock(uiDataRecordSize, uiNoOfRecords), cg);
		dt1->Save(true,true);
		cg->setRecordCount( uiNoOfRecords );
		cg->Save(true,true);
	  dg->Save(true,true);

    m4.Save();
  }
	return 0;
}

#else // reading an MDF4 file

int _tmain(int argc, _TCHAR* argv[])
{
  MDF4File m4;
	m4Block *fh;
  CoInitialize(NULL);
  if (m4.Open(_T("Test.mf4")))
  {
    m4.dump();
    fh=m4.LoadLink(m4.m_Hdr,M4HDBlock::hd_fh_first);
    M4DGBlock *dg = (M4DGBlock *)m4.LoadLink(m4.m_Hdr,M4HDBlock::hd_dg_first);
		if (dg)
		{
			M4CGBlock *cg = (M4CGBlock *)m4.LoadLink(*dg, M4DGBlock::dg_cg_first);
			if (cg)
			{
				M4CNBlock *cn = (M4CNBlock *)m4.LoadLink(*cg, M4CGBlock::cg_cn_first);
				if (cn)
				{
					M4TXBlock *tx = (M4TXBlock *)m4.LoadLink( *cn, M4CNBlock::cn_tx_name);
					int i = 6;
				}
			}
			if (dg->hasLink( M4DGBlock::dg_data ))
			{
				M4DTBlock *dt = (M4DTBlock *)m4.LoadLink( *dg, M4DGBlock::dg_data);
				if (dt)
				{
					M_UINT32 uiDataRecordSize = cg->cg_data_bytes + dg->dg_rec_id_size; 
				  dt->setSize(uiDataRecordSize, (M_UINT32)cg->cg_cycle_count);
					for (M_UINT32 i=0; i<(M_UINT32)cg->cg_cycle_count; i++)
					{
						BYTE *p = (BYTE *)dt->getRecord( i );
						BYTE recid=0; __int64 t; DWORD val;
						if (dg->dg_rec_id_size)
						{
							recid = *p;
							p += dg->dg_rec_id_size;
						}
						t = *(__int64*)p; // time
						p += sizeof(__int64);
						val = *(DWORD*)p; // Value
						//p += sizeof(DWORD);
						// no invalid bytes used here
						printf("Rec %lu: %lu %lu %lu\n",i,(DWORD)recid,(DWORD)t,(DWORD)val);
					}
				}
			}
		}
  }

	return 0;
}

#endif // read/write


