// //////////////////////////////////////////////////////////
// MemMapFile.h
//

#pragma once
#include <stdint.h>
//#ifndef HANDLE
//#define HANDLE void * 
//#endif

struct MemMapFile
{
  MemMapFile() {}
  ~MemMapFile() { close(); }

  /// open file, 
  bool open(const wchar_t *path);
  /// close file
  void close();

  /// raw access
  const unsigned char* getData(size_t offset=0) const;

  /// true, if file successfully opened
  bool isValid() const { return _mappedView != NULL; }


  /// get file size
  uint64_t size() const { return _filesize; }

  /// replace mapping by a new one of the same file, offset MUST be a multiple of the page size
  bool remap(uint64_t offset, size_t mappedBytes);

private:
  /// don't copy object
  MemMapFile(const MemMapFile&)=delete;
  MemMapFile& operator=(const MemMapFile&)=delete;

  /// get OS page size (for remap)
  static int getpagesize();

  /// file size
  uint64_t    _filesize=0;
  /// mapped size
  size_t      _mappedBytes=0;

  /// Windows handle to memory mapping of _file
  HANDLE      _mappedFile=NULL;

  /// file handle
  HANDLE  _file=NULL;
  /// pointer to the file contents mapped into memory
  unsigned char *       _mappedView=NULL;
};
